package gov.va.med.mhv.admin.web.validator;

import java.util.Date;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value = "userSearchValidator")
public class UserSearchValidator implements Validator {

	private static final Pattern pattern = Pattern.compile("^[A-Za-z][0-9][0-9][0-9][0-9]$");
	/*
	private static final Pattern emailPattern = Pattern
			.compile("^[_A-Za-z0-9-]+(\\." + "[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*" + "(\\.[A-Za-z]{2,})$");	
    */
	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {

		String icn = null;
		String firstName = null;
		String lastName = null;

		String email = null;
		String mhvId = null;
		String userName = null;

		String ssnThree = null;
		String ssnTwo = null;
		String ssnFour = null;

		Date birthDate = null;
		String firstPlusFour = null;

		Matcher matcher = null;

		HtmlInputText icnValue = (HtmlInputText) component.getAttributes().get("icn");
		HtmlInputText lastNameValue = (HtmlInputText) component.getAttributes().get("lastName");
		HtmlInputText firstNameValue = (HtmlInputText) component.getAttributes().get("firstName");

		HtmlInputText emailValue = (HtmlInputText) component.getAttributes().get("email");
		HtmlInputText mhvIdValue = (HtmlInputText) component.getAttributes().get("mhvId");
		HtmlInputText userNameValue = (HtmlInputText) component.getAttributes().get("userName");

		HtmlInputText ssnThreeValue = (HtmlInputText) component.getAttributes().get("ssnThree");
		HtmlInputText ssnTwoValue = (HtmlInputText) component.getAttributes().get("ssnTwo");
		HtmlInputText ssnFourValue = (HtmlInputText) component.getAttributes().get("ssnFour");

		UIInput birthDateValue = (UIInput) component.getAttributes().get("birthDate");
		HtmlInputText firstPlusFourValue = (HtmlInputText) component.getAttributes().get("firstPlusFour");

		if (icnValue != null && icnValue.getValue() != null) {
			icn = (String) icnValue.getValue();
		}

		if (lastNameValue != null && lastNameValue.getValue() != null) {
			lastName = (String) lastNameValue.getValue();
		}

		if (firstNameValue != null && firstNameValue.getValue() != null) {
			firstName = (String) firstNameValue.getValue();
		}

		if (emailValue != null && emailValue.getValue() != null) {
			email = (String) emailValue.getValue();
		}

		if (mhvIdValue != null && mhvIdValue.getValue() != null) {
			mhvId = (String) mhvIdValue.getValue();
		}

		if (userNameValue != null && userNameValue.getValue() != null) {
			userName = (String) userNameValue.getValue();
		}

		if (ssnThreeValue != null && ssnThreeValue.getValue() != null) {
			ssnThree = (String) ssnThreeValue.getValue();
		}

		if (ssnTwoValue != null && ssnTwoValue.getValue() != null) {
			ssnTwo = (String) ssnTwoValue.getValue();
		}

		if (ssnFourValue != null && ssnFourValue.getValue() != null) {
			ssnFour = (String) ssnFourValue.getValue();
		}

		if (birthDateValue != null && birthDateValue.getValue() != null) {
			birthDate = (Date) birthDateValue.getValue();
		}

		if (firstPlusFourValue != null && firstPlusFourValue.getValue() != null) {
			firstPlusFour = (String) firstPlusFourValue.getValue();
		}
		// fail validation if certain conditions are not met
		if ((icn == null || icn.isEmpty()) && (firstName == null || firstName.isEmpty())
				&& (email == null || email.isEmpty()) && (mhvId == null || mhvId.isEmpty())
				&& (userName == null || userName.isEmpty()) && (ssnThree == null || ssnThree.isEmpty())
				&& (firstPlusFour == null || firstPlusFour.isEmpty()) && (birthDate == null)
				&& (ssnTwo == null || ssnTwo.isEmpty()) && (ssnFour == null || ssnFour.isEmpty())
				&& (lastName == null || lastName.isEmpty())) {
			
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR,
					bundle.getString("userSearchFormCriteriaErrorHeader"), ""));
		}

		// Combination: First Name and Last Name are less than 2 characters
		if (null != firstName && !firstName.isEmpty() && firstName.trim().length() < 2 && null != lastName
				&& !lastName.isEmpty() && lastName.trim().length() < 2) {
			String emptyDesc = "If searching by Last Name, it must be at least 2 characters. Please check your information and try again.<br/> <li>If searching by First Name, it must be at least 2 characters. Please check your information and try again.</li>";

			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, emptyDesc, ""));
		}

		// Combination: First four does not match the criteria and First Name
		// and Last Name are less than 2 characters
		if (null != firstName && firstPlusFour != null && !firstName.isEmpty() && firstName.trim().length() < 2
				&& null != lastName && !lastName.isEmpty() && lastName.trim().length() < 2) {
			String emptyDesc = "The entry in the 'First Letter of Last Name + Last 4 of SSN' field is invalid. <br/> <li> If searching by Last Name, it must be at least 2 characters. Please check your information and try again.<br/> <li>If searching by First Name, it must be at least 2 characters. Please check your information and try again.</li>";

			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, emptyDesc, ""));
		}

		// Combination: First four does not match the criteria and Last Name is
		// less than 2 characters
		if (firstPlusFour != null && null != lastName && !lastName.isEmpty() && lastName.trim().length() < 2) {
			String emptyDesc = "The entry in the 'First Letter of Last Name + Last 4 of SSN' field is invalid. <br/> <li> If searching by Last Name, it must be at least 2 characters. Please check your information and try again.</li>";

			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, emptyDesc, ""));
		}

		// Combination: First four does not match the criteria and First Name is
		// less than 2 characters
		if (firstPlusFour != null && null != firstName && !firstName.isEmpty() && firstName.trim().length() < 2) {
			String emptyDesc = "The entry in the 'First Letter of Last Name + Last 4 of SSN' field is invalid. <br/> <li> If searching by First Name, it must be at least 2 characters. Please check your information and try again.</li>";

			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, emptyDesc, ""));
		}

		// Combination: ICN does not match the criteria and First Name is less
		// than 2 characters
		if (icn != null && (icn.trim().length() < 10 || icn.trim().length() > 17) && null != firstName
				&& !firstName.isEmpty() && firstName.trim().length() < 2) {
			String emptyDesc = "If searching by First Name, it must be at least 2 characters. Please check your information and try again. <br/> <li> The ICN must be between 10 and 17 characters.</li>";

			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, emptyDesc, ""));
		}

		// Combination: ICN does not match the criteria and Last Name is less
		// than 2 characters
		if (icn != null && (icn.trim().length() < 10 || icn.trim().length() > 17) && null != lastName
				&& !lastName.isEmpty() && lastName.trim().length() < 2) {
			String emptyDesc = "If searching by Last Name, it must be at least 2 characters. Please check your information and try again. <br/> <li> The ICN must be between 10 and 17 characters.</li>";

			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, emptyDesc, ""));
		}

		if (null != lastName && !lastName.isEmpty() && lastName.trim().length() < 2) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(
					new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("lastNameError"), ""));
		}

		if (null != firstName && !firstName.isEmpty() && firstName.trim().length() < 2) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(
					new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("firstNameError"), ""));
		}

		if (icn != null && (icn.trim().length() < 10 || icn.trim().length() > 17)) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(
					new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("userSearchIcnError"), ""));
		}

		/*
		if (email != null) {
			Matcher m = emailPattern.matcher(email);
			if (!m.matches()) {
				ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
						FacesContext.getCurrentInstance().getViewRoot().getLocale());
				throw new ValidatorException(
						new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("invalidEmail"), ""));
			}
		}*/		

		if (firstPlusFour != null) {
			Matcher m = pattern.matcher(firstPlusFour);
			if (!m.matches()) {
				ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
						FacesContext.getCurrentInstance().getViewRoot().getLocale());
				throw new ValidatorException(
						new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("invalidForstPlusFourSum"), ""));
			}
		}

		String ssn = "";

		if (ssnThree != null || ssnTwo != null || ssnFour != null) {

			if (ssnThree != null && ssnTwo != null && ssnFour != null) {

				ssn = ssnThree + "-" + ssnTwo + "-" + ssnFour;

			} else if (ssnThree != null && ssnTwo != null && ssnFour == null) {
				ssn = ssnThree + "-" + ssnTwo;
			} else if (ssnThree == null && ssnTwo != null && ssnFour != null) {
				ssn = ssnTwo + "-" + ssnFour;
			} else if (ssnThree == null && ssnTwo == null && ssnFour != null) {
				ssn = ssnFour;
			} else if (ssnThree == null && ssnTwo != null && ssnFour == null) {
				ssn = ssnTwo;
			} else if (ssnThree != null && ssnTwo == null && ssnFour == null) {
				ssn = ssnThree;
			} else if (ssnThree != null && ssnTwo == null && ssnFour != null) {
				ssn = ssnThree + "-" + ssnFour;

			}

			String expression = "^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$";
			Pattern patternSsn = Pattern.compile(expression);
			matcher = patternSsn.matcher(ssn);
			if (!matcher.matches()) {
				String tempSSn = "'" + ssn + "' is not a valid Social Security Number.";
				throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, tempSSn, ""));
			}

		}

	}

}
